/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Collections.Specialized;
using System.Data;
using Borland.Eco.DataRepresentation;
using Borland.Eco.Persistence;
using Borland.Eco.Persistence.Configuration;
using Borland.Eco.Persistence.Connection;
using Borland.Eco.Persistence.ORMapping;
using Borland.Eco.Services; // this should really move somewhere else

// this should really move somewhere else

namespace Borland.Eco.Internal.DefaultImpl
{
	public delegate DateTime GetDateTimeDelegate();

	public class CommitBlock
	{
		private readonly Datablock m_Changes;
		private readonly Datablock m_OldValues;

		public CommitBlock(Datablock changes, Datablock oldValues)
		{
			m_Changes = changes;
			m_OldValues = oldValues;
		}

		public Datablock Changes
		{
			get { return m_Changes; }
		}

		public Datablock OldValues
		{
			get { return m_OldValues; }
		}
	}

	public interface ISyncSink
	{
		object SyncRoot { get; }
		SyncVersion submit(CommitBlock commitBlock);
	}

	public interface IPersistenceMapperWithIDatabase
	{
		void Fetch(IDatabaseCollection databases, ObjectIdList idList, out Datablock datablock, int[] memberIdList);
		void FetchIDListWithCondition(IDatabaseCollection databases, AbstractCondition condition, out ObjectIdList result, int maxResults, int offset);
		void Update(IDatabaseCollection databases,
		  Datablock datablock, 
		  UpdatePrecondition Precondition, 
		  out IdTranslationList translationList,
		  out int version, 
		  out UpdateResult result,
		  out SyncVersion syncVersion, 
		  ISyncSink syncSink);
		void VersionForTime(IDatabase database, DateTime clockTime, out int Version);
		void TimeForVersion(IDatabase database, int version, out DateTime clockTime);
	}

	public interface IPersistenceHandleDbImpl
	{
		void CreateDataBaseSchema(ITypeSystemService typeSystemService,
			IDatabaseCollection databases,
			string dbName,
			IORMappingProvider newMappingProvider,
			IORMappingProvider oldMappingProvider,
			IConfigureCleanPS configureCleanPS);
		/// <summary>
		/// This method returns a script that can be used to create the schema
		/// </summary>
		StringCollection CreateSchemaScript(ITypeSystemService typeSystemService,
			IDatabaseCollection databases,
			string dbName,
			IORMappingProvider newMappingProvider,
			IORMappingProvider oldMappingProvider);
		IDBEvolutor GetEvolutor(ITypeSystemService typeSystemService,
			IDatabaseCollection databases,
			string dbName, 
			IORMappingProvider newMappingProvider,
			IORMappingProvider oldMappingProvider);
		IPersistenceMapperWithIDatabase GetPersistenceMapper(ITypeSystemService typeSystemService,
			IDatabaseCollection databases,
			ORMappingDefinition mapping,
			TimeSpan versionGranularity, 
			GetDateTimeDelegate getTime);
		bool ValidateSchemaStructure(StringCollection remedies, 
			ITypeSystemService typeSystemService, 
			IDatabaseCollection databases,
			string dbName,
			IORMappingProvider mappingProvider);
		bool ValidateDataStructure(StringCollection remedies,
			ITypeSystemService typeSystemService,
			IDatabaseCollection databases,
			string dbName,
			IORMappingProvider mappingProvider);
	}

	public interface IDBEvolutor
	{
		void CalculateScript();
		string[] GenerateDbScript();
		string[] GenerateMappingScript();
		string[] GenerateWarnings();
		string[] GenerateErrors();
		string[] GenerateExecutedStatements();
		void ExecuteScript();
		FormerNamesHandler GetFormerNamesHandler();
		IDatabase Database { get; }
	}
}

namespace Borland.Eco.Persistence
{
	public interface IAttributemapping
	{
		String[] ColumnNames(string name);
		String[] ColumnTypes(int length);
		String[] DefaultDbValues(string modeledValue, SqlDatabaseConfig sqlDatabaseConfig);
		void ValueToParameters(System.Object value, IDataParameter[] parameters);
		System.Object ColumnsToValue(System.Object[] columnValues);
		bool IsEqual(System.Object value, System.Object[] columnValues);
	}

	public interface ISingleColumnAttributemapping
	{
		String ColumnName(string name);
		String ColumnType(int length);
		String DefaultDbValue(string modeledValue, SqlDatabaseConfig sqlDatabaseConfig);
		void ValueToParameter(System.Object value, IDataParameter parameter);
		void StringToParameter(string value, IDataParameter parameter);
		System.Object ColumnToValue(System.Object columnValue);
		bool IsEqual(System.Object value, System.Object columnValue);
	}

	public interface IAutoIncAttributemapping: ISingleColumnAttributemapping
	{
		void MakeColumnAutoInc(string tableName, string columnName, IDatabase database);
	}

	public interface INonBooleanBooleanMapping
	{
		string TrueString { get; }
	}
}
